﻿uses
  Classes, Common, DataEntry, DataStorage, Regex, SysUtils;

procedure OnStartFilter(aDataStore: TDataStore; Var DoContinue: boolean; Var OutObj: TObject);
var
  DataStore: TDataStore;
begin
  DoContinue := True;
  DataStore := GetDataStore(DATASTORE_FILESYSTEM); // Identifies the data store of the column
  if DataStore = nil then
    Exit;
  try
    OutObj := DataStore.DataFields.FieldByName('HASHSET'); // noslz
  finally
    DataStore.free;
  end;
end;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
var
  col_result_str: string;
  Column: TDataStoreField;
begin
  Result := 1; // Include
  Column := TDataStoreField(InObj);
  if assigned(anEntry) and assigned(Column) then
  begin
    col_result_str := Column.AsString[anEntry];
    if (col_result_str <> '') then
    begin
      Result := -1; // Exclude {a file is excluded if the hashset column is not empty}
    end;
  end;
end;

begin

end.
